package w83b.w83bDAO;

import java.util.List;

import w83b.w83bBeans.W83bCertificacionesBean;




// TODO: Auto-generated Javadoc
/**
 * The Interface W83bIActasDAO.
 */
public interface W83bICertificacionesDAO {

	
	/**
	 * Carga certificacion Num Del Cent Sind.
	 *
	 * @param param the param
	 * @return the W83bCertificacionesBean
	 * @throws Exception the exception
	 */
	
	public W83bCertificacionesBean cargaCertificacionNumDelCentSind(W83bCertificacionesBean param) throws Exception;
	/**
	 * Carga certificacion Cent sind.
	 *
	 * @param param W83bCertificacionesBean
	 * @return the W83bCertificacionesBean
	 * @throws Exception the exception
	 */
	public  W83bCertificacionesBean cargaCertificacionSindMasRepresent(W83bCertificacionesBean param) throws Exception;
	public List cargaCertificacionCentSind(W83bCertificacionesBean param, String texto) throws Exception;

	/**
	 * Prepara la lista de convenios con la informacin necesaria para cargar el certificado
	 *
	 * @param param the param
	 * @return List lista de convenios
	 * @throws Exception the exception
	 */
	public List cargaCertificacionSindConv(W83bCertificacionesBean param) throws Exception;
	
	/**
	 * Prepara los datos generales del certificado organo de representacin 
	 *
	 * @param param W83bCertificacionesBean
	 * @return List lista de delegados
	 * @throws Exception the exception
	 */	
	public W83bCertificacionesBean cargaDatosGeneralesCertificacionOrganoRepresentacion(W83bCertificacionesBean param) throws Exception;
	
	/**
	 * Prepara la lista de delegados
	 *
	 * @param param W83bCertificacionesBean
	 * @return List lista de delegados
	 * @throws Exception the exception
	 */
	public List cargaListaDelegados (W83bCertificacionesBean param) throws Exception ;
	/**
	 * Recupera el nombre de un firmante teniendo en cuenta el territorio y el firmante seleccionado
	 * @param W83bCertificacionesBean param  
	 * @return String el nombre del firmante
	 * @throws Exception
	 */
	public String recuperarNombreFirmante(W83bCertificacionesBean param) throws Exception;
	/**
	 * Recupera el cargo de un firmante teniendo en cuenta el territorio y el firmante seleccionado
	 * @param W83bCertificacionesBean param  
	 * @return String el nombre del firmante
	 * @throws Exception
	 */
	public String recuperarCargoFirmante(W83bCertificacionesBean param) throws Exception ;
	/**
	 * Recupera el cdigo de la localidad del territorio
	 * @param W83bCertificacionesBean param  
	 * @return String el cdigo de la localidad del territorio
	 * @throws Exception
	 */
	public String recuperarLocalidadFirmante(W83bCertificacionesBean param) throws Exception;
	
	/**
	 * Recupera el cdigo del sindicato seleccionado
	 * @param W83bCertificacionesBean param  
	 * @return String el cdigo del sindicato seleccionado
	 * @throws Exception
	 */
	public String recuperarCodigoSindicato(W83bCertificacionesBean param) throws Exception;
	/**
	 * Recupera los delegados y los datos del acta
	 * @param W83bCertificacionesBean param  
	 * @return W83bCertificacionesBean
	 * @throws Exception
	 */
	public W83bCertificacionesBean cargaCertificacionEmpresa(W83bCertificacionesBean param) throws Exception;
	public String cargaCertificacionNegativoConvocatoria(W83bCertificacionesBean param) throws Exception;
	public W83bCertificacionesBean cargaCertificacionNegativoRepresentatividad(W83bCertificacionesBean param) throws Exception;
	public List cargaDescripcionSindicato(W83bCertificacionesBean param) throws Exception;
	public List cargaCertificacionPorSectores(W83bCertificacionesBean param) throws Exception;
	public List cargaCertificacionPorSectoresTotales(W83bCertificacionesBean param) throws Exception;

}


